# Confidence AWS warehouse / connector setup for Terraform 

This repository contains a terraform template that creates AWS resources needed for Confidences' integration with Redshift. It will not
create or modify your Redshift cluster, we assume that this already exists. 


## Created resources

* An S3 bucket to contain the Parquet files uploaded by Confidence that are then loaded into Redshift. 
* An IAM role that has permissions to read & write from the S3 bucket and access the Redshift cluster
* An IAM User with credentials that has permissions to assume the IAM role. 

## Applying the template

```
> terraform init
> terraform plan -out tfplan -var-file=example.tfvars
> terraform apply tfplan
...
...
Apply complete! Resources: 6 added, 0 changed, 0 destroyed.

Outputs:
access_key_id = "AKIASZEAG6UL64X4PD5N"
access_key_secret = <sensitive>
role_arn = "arn:aws:iam::<account>:role/confidence-role"

# To get the secret value you can run the following
terraform output -raw access_key_secret
```

Keep track of the `tfstate` to be able to destroy the resources created by the template when needed.
