# Confidence AWS warehouse / connector setup for Terraform 

This repository contains a terraform template that creates AWS resources needed for Confidences' integration with Redshift. It will not
create or modify your Redshift cluster, we assume that this already exists. 


## Created resources

* An S3 bucket to contain the Parquet files uploaded by Confidence that are then loaded into Redshift. 
* An IAM role that has permissions to read & write from the S3 bucket and access the Redshift cluster. The role will have a trust policy setup so that the Confidence GCP service account can assume the role securely without having to store any credentials. 

## Applying the template

```
> terraform init
> terraform plan -out tfplan -var-file=example.tfvars
> terraform apply tfplan
...
...

Apply complete! Resources: 3 added, 0 changed, 0 destroyed.

Outputs:

role_arn = "arn:aws:iam::191394936087:role/confidence-role-webidentity"
```

Keep track of the `tfstate` to be able to destroy the resources created by the template when needed.
