# Confidence BQ warehouse / connector setup for Terraform 

This repository contains a terraform template that creates GCP resources needed for Confidences' integration with BigQuery. It will create
a dataset for Confidence to write to.

## Created resources

* A BigQuery dataset `confidence_assigned` where Confidence can write assignment events.
* A BigQuery dataset `confidence_metrics` where Confidence can write exposure tables (one will be created for each experiment).
* A GCP Service Account with BigQuery Job User permission that Confidence can act on behalf on, it will be owner on the datasets above.

Note: You will need to manually give the created service account access to specific datasets that Confidence should be able to create metrics from.

## Applying the template

```
terraform init
terraform plan -out tfplan -var-file=example.tfvars
terraform apply tfplan
...
...

Apply complete! Resources: 3 added, 0 changed, 0 destroyed.
```

Keep track of the `tfstate` to be able to destroy the resources created by the template when needed.
